/**
 * @file   qspiIO.h
 * @author StepTechnica
 * @date   Sep. 05, 2025
 * 
 * @brief Evaluation Board pwb_[t@CuMKY43foCXv
 * 
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 * 
 * ̃\tgEFÁARs[pAzzAύX̒ǉAύX̍ĔzzAppAL̔ȂǁAǂȂRɂgƂł܂B
 * ̃\tgEFAɂ͕ۏ؂͂Ă܂B
 * ̃\tgEFA𗘗pƂŖ肪NۂɁA\tgEFA̐҂͈؂̐ӔC𕉂܂B
 * 
 */


#ifndef __qspi_IO__

#define __qpsi_IO__


/* -----------------------------------------------------------------------------
 * #define}N`
 */
#define 	kSPI_CMD_READ           0x03	// Standard read.
#define 	kSPI_CMD_FARST_READ     0x0b	// First read.
#define 	kSPI_CMD_DOR            0x3b	// Dual output read.
#define 	kSPI_CMD_QOR            0x6b	// Quad output read.
#define 	kSPI_CMD_DIOR           0xbb	// Dual in/out read.
#define 	kSPI_CMD_QIOR           0xeb	// Quad in/out read.
#define 	kSPI_CMD_SPIS_READ      0x05	// SPI status read.
#define 	kSPI_CMD_RDID           0x9f	// ID read.

#define 	kSPI_CMD_WRITE          0x02	// Standard write.
#define 	kSPI_CMD_DIW            0xA2	// Dual input write.
#define 	kSPI_CMD_QIW            0x32	// Duad input write.
#define 	kSPI_CMD_DIOW           0xA1	// Dual in/out write.
#define 	kSPI_CMD_QIOW           0xd2	// Duad in/out write.
#define 	kSPI_CMD_SPIS_WRITE     0x01	// SPI status write.

#define 	DEF_QSPI_PRESCALER      9   	// QSPĨvXP[lB216924MHz
#define 	DEF_QSPI_AREALENGTH     0x4000	// 0~0x3FFF 14bit address
#define 	DEF_QSPI_AREABIT        13  	// 14 = 13 + 1
#define 	DEF_SPI_DUMMY           2   

extern int QSPI_Initialize(void);
extern int MKY_Read16(unsigned short offset);
extern int MKY_ReadBlock(unsigned short offset, void* block, unsigned short length);
extern int MKY_Write16(unsigned short offset, unsigned short value);
extern int MKY_WriteBlock(unsigned short offset, const void* block, unsigned short length);
extern int MKY_FillMemory(unsigned short offset, int value, unsigned short length);

#endif	//  __qpsi_IO__
