/**
 * @file   MKY49.h
 * @author StepTechnica
 * @date   Sep. 05, 2025
 * 
 * @brief Evaluation Board 用ヘッダーファイル「MKY49デバイス」
 * 
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 * 
 * このソフトウェアは、コピー利用、配布、変更の追加、変更を加えたもの再配布、商用利用、有料販売など、どなたも自由にお使いいただくことができます。
 * このソフトウェアには保証はついていません。
 * このソフトウェアを利用したことで問題が起きた際に、ソフトウェアの製作者は一切の責任を負いません。
 * 
 */

#ifndef MKY_49_H
#define MKY_49_H

/* -----------------------------------------------------------------------------
 * #defineマクロ定義
 */
#define MKY_49							//プリプロセッサのデバイス識別用

#define MKY_MEMORY_BASE		0x00000000	//メモリ開始アドレス
#define MKY_MEMORY_SIZE		0x3FFF		//メモリサイズ
#define MAX_ACCESS_SIZE		(0x800)		//コマンドからアクセスできるメモリのサイズ

#define MKY_OFS_MEMORY		0			//メモリ初期化 オフセット
#define MKY_LEN_MEMORY		0x200		//メモリ初期化 長さ

#define MKY_OFS_MEMORY_1	0x2100		//メモリ初期化 後半 オフセット
#define MKY_LEN_MEMORY_1	0x300		//メモリ初期化 後半 長さ


#define MKY49_GM_BASE_ADDR      0x0000    // グローバメモリ
#define MKY49_MSB_BASE_ADDR     0x2100    // メール送信バッファ
#define MKY49_MRB0_BASE_ADDR    0x2200    // メール受信バッファ0
#define MKY49_MRB1_BASE_ADDR    0x2300    // メール受信バッファ1
#define MKY49_GM_SIZE           0x200     //
#define MKY49_MSB_SIZE          0x100     //
#define MKY49_RM0_SIZE          0x100     //
#define MKY49_RM1_SIZE          0x100     //
#define MKY49_OFSSTATUS         MKY49_GM_SIZE	//通信ステータス オフセット
#define MKY49_LENSTATUS         0x020        	//通信ステータス 長さ

// --------------------
// リンク検出
#define MKY49_RFR       0x0200    // Receive Flag Register 64bit
#define MKY49_LFR       0x0208    // Link Flag Register 64bit

// --------------------
// メンバ検出
#define MKY49_MFR       0x0210    // Member Flag Register 64bit

// -----------------------
// システム補助
#define MKY49_CCTR      0x0218    // Care CounTer Register 16bit

// -----------------------
// システム補助
#define MKY49_MGM       0x0220    // 

// -----------------------
// システム
#define MKY49_FSR       0x021A    // Final Station Register 16bit
#define MKY49_SSR0      0x021C    // System Status Register 16bit
#define MKY49_SSR1      0x021E    // System Status Register 16bit
#define MKY49_CCR       0x04F8    // Chip Code Register 64bit
#define MKY49_BCR0      0x0500    // Basic Control Register 16bit
#define MKY49_BCR1      0x0502    // Basic Control Register 16bit
#define MKY49_SCR       0x0504    // System Control Register 16bit

// ----------------------
// メール送信
#define MKY49_MSCR      0x0508    // Mail Send Control Register 16bit
#define MKY49_MESR      0x050C    // Mail Error Status Register 16bit
#define MKY49_MSRR      0x050E    // Mail Send Result Register  16bit
#define MKY49_MSLR      0x0510    // Mail Send Limit time Register 16bit

// ----------------------
// メール受信
#define MKY49_MR0CR     0x0514    // Mail Receive 0 Control Register 16bit
#define MKY49_MR0SR     0x0516    // Mail Receive 0 Status Register 16bit
#define MKY49_MR1CR     0x0518    // Mail Receive 1 Control Register 16bit
#define MKY49_MR1SR     0x051A    // Mail Receive 1 Status Register 16bit

// -----------------------
// システム
#define MKY49_NFSR      0x051C    // New Final Station Register 16bit

// -----------------------
// 割込み制御
#define MKY49_ITCR      0x0520    // Interrupt Timing 0 Control Register 16bit
#define MKY49_INTCR     0x0524    // INTerrupt 0 Control Register 16bit
#define MKY49_INTSR     0x0528    // INTerrupt 0 Status Register 16bit
#define MKY49_INTRR     0x052C    // INTerrupt 0 Release Register 16bit

// -----------------------
// システム
#define MKY49_SSR1CR    0x0530    // System Status Clear Register1 16bit

// -----------------------
// システム補助
#define MKY49_CCTCR     0x0534    // Care CounTer Clear Register 16bit

// ---------------------
// リンク検出
#define MKY49_LGR       0x0538    // Link Group Register 64bit

// ---------------------
// メンバ検出
#define MKY49_MGR       0x0540    // Memory Group Register 64bit

// -----------------------
// システム補助
#define MKY49_QCR       0x0548    // Query Control Register 16bit
#define MKY49_DOUT      0x054C    // Data Out port
#define MKY49_DIN       0x0550    // Data In port
#define MKY49_DOUTFB    0x0552    // Data Out port FeedBack

// -----------------------
// デバッグ
#define OFS_regRXD 			0x1A60      //nDout0-3/nDin0-3







// -----------------------
// 起動時 CCRチェック
#define	VAL_CCR				"MKY49_10"

// -----------------------
// SSR0 CUnet ステータス
#define BIT_regSSR0_START	8			//START bit
#define BIT_regSSR0_RUN  	9			//RUN phase bit
#define BIT_regSSR0_CALL 	10			//CALL phase bit
#define BIT_regSSR0_BRK  	11			//BReaK phase bit
#define BIT_regSSR0_GMM  	15			//Global Memory Monitor bit


#endif//MKY_49_H//MKYデバイス初期化。
