/**
 * @file   MKY43.c
 * @author StepTechnica
 * @date   Sep. 05, 2025
 *
 * @brief Evaluation Board 用ソースファイル「MKY43依存部分」
 *
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 *
 * このソフトウェアは、コピー利用、配布、変更の追加、変更を加えたもの再配布、商用利用、有料販売など、どなたも自由にお使いいただくことができます。
 * このソフトウェアには保証はついていません。
 * このソフトウェアを利用したことで問題が起きた際に、ソフトウェアの製作者は一切の責任を負いません。
 *
 */

/* -----------------------------------------------------------------------------
 * #include
 */

#include "MKY49.h"

#include "main.h"
#include <memory.h>
#include <stdint.h>
#include <stdbool.h>
#include "IB49config.h"
#include "qspiIO.h"

/* -----------------------------------------------------------------------------
 * #defineマクロ定義
 */
#define	CNT_RESET	100	// Reset Cycle count

/* -----------------------------------------------------------------------------
 * 変数定義
 */
#ifdef DEBUG
char strPROMPT[16] = {"MKY49_D>"};
#else
char strPROMPT[16] = {"MKY49>"};
#endif

/* -----------------------------------------------------------------------------
 * 関数プロトタイプ宣言
 */


int MKY_Initialize(void);



/**
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * @brief：MKYデバイス初期化
 *
 * @note： 基板の設定を読み込み、初期値を格納する
 *
 * @param  none
 * @retval true : 正常終了
 *
 */
int MKY_Initialize(void)
{
	int i;

	QSPI_Initialize();

	drvMKYRESET(false);
	for(i=0; i<CNT_RESET; i++) {
	}
	drvMKYRESET(true);

	return true;

}

