/**
 * @file   ctrlUART4.h
 * @author StepTechnica
 * @date   Sep. 05, 2025
 * 
 * @brief Evaluation Board 用ヘッダーファイル「UART(4)制御」
 * 
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 * 
 * このソフトウェアは、コピー利用、配布、変更の追加、変更を加えたもの再配布、商用利用、有料販売など、どなたも自由にお使いいただくことができます。
 * このソフトウェアには保証はついていません。
 * このソフトウェアを利用したことで問題が起きた際に、ソフトウェアの製作者は一切の責任を負いません。
 * 
 */

#ifndef INC_CTRLUART4_H_
#define INC_CTRLUART4_H_

#include "charDef.h"

/* -----------------------------------------------------------------------------
 * #defineマクロ定義
 */

#define ERR_SCIBASE 	1000
#define ERR_CHKBARD 	(ERR_SCIBASE + 1)
#define ERR_CHKDTLEN	(ERR_SCIBASE + 2)
#define ERR_CHKSPLEN	(ERR_SCIBASE + 3)
#define ERR_CHKPARTY	(ERR_SCIBASE + 4)
#define ERR_CHKLFCOD	(ERR_SCIBASE + 5)
#define ERR_FULLTXBUF	(ERR_SCIBASE + 6)
#define ERR_FULLRXBUF	(ERR_SCIBASE + 7)


#define SZ_SIOBUF      	0x01000		// 4K
#define MSK_POINTER 	0x00FFF

// reBuf
#define BIT_NzERR    	0x20
#define BIT_BfERR    	0x10
#define BIT_FrERR    	0x08
#define BIT_PaERR    	0x04
#define BIT_ORERR    	0x02

/* -----------------------------------------------------------------------------
 * enumタグ定義 (typedefを同時に行う)
 */

typedef enum
{
	Baud9600     = 9600,
	Baud14400    = 14400,
	Baud19200    = 19200,
	Baud38400    = 38400,
	Baud57600    = 57600,
	Baud115200   = 115200,
	Baud230400   = 230400
} termBaudRare;

typedef enum
{
//	DATALen7     = 7,
	DATALen8     = 8,
	DATALen9     = 9
} termDataLength;

typedef enum
{
	STOPLEN1     = 1,
	STOPLEN2     = 2
} termStopLength;

typedef enum
{
	PARITYNONE   = 0,
	PARITYODD    = 1,
	PARITYEVEN   = 2
} termParity;

typedef enum
{
	LFC_LF       = 0,
	LFC_CRLF     = 1,
	LFC_CR       = 2
} termLFCode;

/* -----------------------------------------------------------------------------
 * typedef定義
 */
typedef struct _SCI_CONFIG_
{
	termBaudRare  	Baud;	//   9600
	              	     	//  14400
	              	     	//  19200
	              	     	//  38400
	              	     	//  57600
	              	     	// 115200
	              	     	// 230400
	termDataLength	DtLen;	// (7 or) 8 or 9
	termStopLength	StLen;	// 1 or 2
	termParity    	Parity;	// 0 = none, 1= odd, 2 = even
	termLFCode    	LFCode;	// 0=<LF>, 1=<CR><LF>, 2=<CR>
} SCI_CONFIG;

/* -----------------------------------------------------------------------------
 * extern変数宣言
 */
extern unsigned char	txBuf[SZ_SIOBUF];
extern unsigned char	rxBuf[SZ_SIOBUF];
extern unsigned char	reBuf[SZ_SIOBUF];
extern unsigned short	wp_txBuf;
extern unsigned short	rp_txBuf;
extern unsigned short	wp_rxBuf;
extern unsigned short	rp_rxBuf;
extern char         	gLFcode;
extern unsigned char	gLFbuf[4];
extern char         	gTxBusy;

/* -----------------------------------------------------------------------------
 * 関数宣言
 */
extern void  dbUART4_IRQHandler(void);
extern void  init_GPIO_UART4(void);
extern short init_UART(SCI_CONFIG *sciParam);
extern short print_char(char c);
extern short print_string(char *str);

#endif /* INC_CTRLUART4_H_ */
