/**
 * @file   charDef.h
 * @author StepTechnica
 * @date   Sep. 05, 2025
 *
 * @brief 文字コード定義
 *
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 *
 * このソフトウェアは、コピー利用、配布、変更の追加、変更を加えたもの再配布、商用利用、有料販売など、どなたも自由にお使いいただくことができます。
 * このソフトウェアには保証はついていません。
 * このソフトウェアを利用したことで問題が起きた際に、ソフトウェアの製作者は一切の責任を負いません。
 *
 */
/*
 * charDef.h
 *
 *  Created on: Nov 24, 2023
 *      Author: maeda
 */

#ifndef IO_CHARDEF_H_
#define IO_CHARDEF_H_

#define CHR_NUL      	0x00   // null文字
#define CHR_SOH      	0x01   // ヘッダ開始
#define CHR_STX      	0x02   // テキスト開始
#define CHR_ETX      	0x03   // テキスト終了
#define CHR_EOT      	0x04   // 転送終了
#define CHR_ENQ      	0x05   // 照会
#define CHR_ACK      	0x06   // 受信ＯＫ
#define CHR_BEL      	0x07   // 警告
#define CHR_BS       	0x08   // 後退
#define CHR_HT       	0x09   // 水平タブ
#define CHR_LF       	0x0A   // 改行
#define CHR_VT       	0x0B   // 垂直タブ
#define CHR_FF       	0x0C   // 改頁
#define CHR_CR       	0x0D   // 復帰
#define CHR_SO       	0x0E   // シフトアウト
#define CHR_SI       	0x0F   // シフトイン
#define CHR_DLE      	0x10   // データリンクエスケープ
#define CHR_DC1      	0x11   // 装置制御１
#define CHR_DC2      	0x12   // 装置制御２
#define CHR_DC3      	0x13   // 装置制御３
#define CHR_DC4      	0x14   // 装置制御４
#define CHR_NAK      	0x15   // 受信失敗
#define CHR_SYN      	0x16   // 同期
#define CHR_ETB      	0x17   // 転送ブロック終了
#define CHR_CAN      	0x18   // とりけし
#define CHR_EM       	0x19   // メディア終了
#define CHR_SUB      	0x1A   // 置換
#define CHR_ESC      	0x1B   // エスケープ
#define CHR_FS       	0x1C   // フォーム区切り
#define CHR_GS       	0x1D   // グループ区切り
#define CHR_RS       	0x1E   // レコード区切り
#define CHR_US       	0x1F   // ユニット区切り
#define CHR_SPC      	0x20   // スペース
#define CHR_DEL      	0x7F   // 削除



#endif /* IO_CHARDEF_H_ */
