/**
 * @file   Utility.h
 * @author StepTechnica
 * @date   Sep. 05, 2025
 * 
 * @brief Evaluation Board 用ヘッダーファイル「ユーティリティ」
 * 
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 * 
 * このソフトウェアは、コピー利用、配布、変更の追加、変更を加えたもの再配布、商用利用、有料販売など、どなたも自由にお使いいただくことができます。
 * このソフトウェアには保証はついていません。
 * このソフトウェアを利用したことで問題が起きた際に、ソフトウェアの製作者は一切の責任を負いません。
 * 
 */

#ifndef UTILITY_H
#define UTILITY_H

/* -----------------------------------------------------------------------------
 * #include
 */
#include <stdint.h>

/* -----------------------------------------------------------------------------
 * 関数プロトタイプ宣言
 */

//
void reset_mkyDevice(void);
extern void reset_usbPhy(void);

// 指定された時間待つ
void delay_us(uint16_t us);
void delay_ms(uint16_t us);

// 64ビットの整数を、16桁になるよう0パディングした文字列に変換する
void Uint64ToHexStr(char* dest, uint64_t val);
// 2byte単位のスワップを行う。
void SwapWord(uint16_t* d);
// 4byte単位のスワップを行う。
void SwapLong(uint32_t* d);
// 8byte単位のスワップを行う。
void SwapLongLong(uint64_t* d);

// 文字列中の小文字を大文字に変換する
// str : 変換対象文字列
// maxLen : 変換するバイト数のリミット
void StrToUpper(char* str, int maxLen);

// 文字列を16進数として変換した値を返す
short getHexStrings(char* hexstring, short format);

// 文字列を数値に変換する
short strToBin(char* com, unsigned long* a);

// 文字列からトークン切り出す
long divideToken(unsigned char *str, char *argv[]);

#endif//UTILITY_H
