/**
 * @file   IB49config.h
 * @author StepTechnica
 * @date   Sep. 05, 2025
 * 
 * @brief Evaluation Board 用ヘッダーファイル「IB493ボード設定」
 * 
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 * 
 * このソフトウェアは、コピー利用、配布、変更の追加、変更を加えたもの再配布、商用利用、有料販売など、どなたも自由にお使いいただくことができます。
 * このソフトウェアには保証はついていません。
 * このソフトウェアを利用したことで問題が起きた際に、ソフトウェアの製作者は一切の責任を負いません。
 * 
 */

#ifndef MKY_IB49_H
#define MKY_IB49_H

/* -----------------------------------------------------------------------------
 * #include
 */

#include "MKYDevice.h"
#include "MKY49.h"

/* -----------------------------------------------------------------------------
 * enumタグ定義 (typedefを同時に行う)
 */
//MKYデバイスがどのバスでつながっているか。
enum en_mky_bus
{
	MKY_BUS_UNKNOWN,
	MKY_BUS_16,
	MKY_BUS_8,
	MKY_BUS_SPI
};
typedef enum en_mky_bus EN_MKY_BUS;


//エンディアン
enum en_mky_endian
{
	MKY_ENDIAN_UNKNOWN,
	MKY_ENDIAN_LITTLE,
	MKY_ENDIAN_BIG,
};
typedef enum en_mky_endian EN_MKY_ENDIAN;


/* -----------------------------------------------------------------------------
 * 関数プロトタイプ宣言
 */

extern char readSW7Data(void);
extern char readSW7_1(void);
extern char readSW7_2(void);
extern char readSW7_3(void);
extern char readSW7_4(void);
extern char readSW7_5(void);
extern char readSW7_6(void);
extern char readSW7_7(void);
extern char readSW7_8(void);

extern void drvLED8(char sw);
extern void drvLED9(char sw);
extern void drvLED10(char sw);
extern void drvLED11(char sw);
extern void drvLED12(char sw);
extern void drvLED13(char sw);
extern void drvLED14(char sw);
extern void drvLED15(char sw);

extern void drvMKYRESET(char sw);

extern char isMODEon(void);
extern char isInt0on(void);
extern char isInt1on(void);
extern char isPFon(void);
extern void setSPI2_CS(char sw);


extern void LedSw_main(void);

extern void blinkLED1(void);

#endif//MKY_IB49_H
