/**
 * @file   dbTerm.h
 * @author StepTechnica
 * @date   Sep. 05, 2025
 * 
 * @brief Evaluation Board 用ヘッダーファイル「ターミナルコンソール」
 * 
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 * 
 * このソフトウェアは、コピー利用、配布、変更の追加、変更を加えたもの再配布、商用利用、有料販売など、どなたも自由にお使いいただくことができます。
 * このソフトウェアには保証はついていません。
 * このソフトウェアを利用したことで問題が起きた際に、ソフトウェアの製作者は一切の責任を負いません。
 * 
 */

#ifndef INC_DBTERM_H_
#define INC_DBTERM_H_

/* -----------------------------------------------------------------------------
 * #defineマクロ定義
 */
#define NoData  	0
#define MAX_CMDT_LENGTH 	1024

// define when Processor is BigEndian
// #define SWAP_BIGENDIAN


/* -----------------------------------------------------------------------------
 * enumタグ定義 (typedefを同時に行う)
 */
typedef enum _SubProcessKind
{
    SubProcessNone = 0,               	// 無し
	SubProcessContinueReadWrite,      	// 連続して表示と書込を行う
	SubProcessContinueWrite,          	// 連続して書込を行う
	SubProcessSpecifiedCountReadWrite,	// 指定回数だけ表示と書込を行う
}SubProcessKind;

/* -----------------------------------------------------------------------------
 * typedef定義
 */
typedef struct _SubProcessState
{
    SubProcessKind Kind;    // 処理の種類
    int Format;             // 何バイト単位でのアクセスか
    unsigned TargetOffset;  // 処理対象のレジスタへのオフセット
    const char* TargetName; // 処理対象の表示に別名がある場合文字列のアドレス。ない場合は0
	int Count;				// 何回アクセスするか。SubProcessSpecifiedCountReadWriteの時のみ利用される
}SubProcessState_st;



#define MONITOR_COMMAND(cmd, func)		{ cmd, sizeof(cmd)/sizeof(char), func }

typedef struct _mon_table {
	const char	*command ;								// モニタからのコマンド
	int 		cmdLen ;								// コマンド文字列の長さ
	short		(*myfunction)(int argc, char *argv[]) ;	// 実処理関数
} MONITOR_TABLE ;




/* -----------------------------------------------------------------------------
 * 関数宣言
 */
extern short dbTerm_initialize(void);
extern short dbTerm_main(void);
extern short dbTerm_md(int argc, char *argv[]);
extern short dbTerm_mw(int argc, char *argv[]);
extern short dbTerm_mm(int argc, char *argv[]);
extern short dbTerm_din(int argc, char *argv[]);
extern short dbTerm_dout(int argc, char *argv[]);
extern short getFormatOption(char* format);
extern void md_dump(short offset, short length, short format);
extern void dump_ascii_line(unsigned char* line, short length);
extern void subDbTermStart(SubProcessKind kind, short offset, short format, const char* name, int count);
extern void dBTermShowReg(short offset, const char* name, short format, short showAscii);
extern void showDbTermPrompt(void);
extern void showMemValue(unsigned char data[], short format);


#endif /* INC_DBTERM_H_ */
