/**
 * @file   MKYDevice.h
 * @author StepTechnica
 * @date   Sep. 05, 2025
 * 
 * @brief Evaluation Board 用ヘッダーファイル「MKYデバイスアクセス共通」
 * 
 * @copyright (C) 2022- StepTechnica Co.,Ltd.
 * 
 * このソフトウェアは、コピー利用、配布、変更の追加、変更を加えたもの再配布、商用利用、有料販売など、どなたも自由にお使いいただくことができます。
 * このソフトウェアには保証はついていません。
 * このソフトウェアを利用したことで問題が起きた際に、ソフトウェアの製作者は一切の責任を負いません。
 * 
 */

#ifndef MKY_DEVICE_H
#define MKY_DEVICE_H

/* -----------------------------------------------------------------------------
 * #defineマクロ定義
 */
#define MEMORY_SIZE     	0x800

/* -----------------------------------------------------------------------------
 * enumタグ定義 (typedefを同時に行う)
 */
typedef enum _AccessEndian
{
    AccessEndianLittle = 0,
    AccessEndianBig,
}AccessEndian;

/* -----------------------------------------------------------------------------
 * extern変数宣言
 */
extern AccessEndian GetAccessEndian();

/* -----------------------------------------------------------------------------
 * extern関数宣言
 */
extern int MKY_Initialize(void);
extern int MKY_Read16(unsigned short offset);
extern int MKY_ReadBlock(unsigned short offset, void* block, unsigned short length);
extern int MKY_Write16(unsigned short offset, unsigned short value);
extern int MKY_WriteBlock(unsigned short offset, const void* block, unsigned short length);
extern int MKY_FillMemory(unsigned short offset, int value, unsigned short length);
extern AccessEndian GetAccessEndian();

#endif//MKY_DEVICE_H
