
#pragma once
#define HLSBAPI __stdcall

#define HLS_SUCCESS			0	/* I */
#define HLS_ERR_ALREADYOPENED	1	/* łɃI[vĂ */
#define HLS_ERR_CLOSED			2	/* HlsOpen()xR[ĂȂ */
#define HLS_ERR_INVALIDPARAM	3	/* ȃp[^ŃR[ꂽ */
#define HLS_ERR_FAILED			4	/* sɂ菈sȂ */
#define HLS_ERR_NORESOUCE		5	/* sɕKvȃ\[XȂ */
#define HLS_ERR_DEVICENOTEXIST	7	/* foCX݂Ȃ */
#define HLS_NOTCALLYET			99	/* ܂1xHLSBAPIR[ĂȂ */

/**************************************************************************/
/* STRUCTs */
/**************************************************************************/
typedef struct
{
	int		fh;		/* FULL = 1 / HALF = 0 */
	int 	bps;	/* 3 or 6 or 12 */
	int		dae;	/* High = 1 / Lo = 0 */
} status33;

typedef struct
{
	status33	ch1,ch2;
} HlsbStat;

/**************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

UINT HLSBAPI HlsGetVersion( void );
UINT HLSBAPI HlsGetLastError( void );

// Legacy API
BYTE HLSBAPI HlsGetCNo( const UINT );
BOOL HLSBAPI HlsSetCNo( const UINT, const BYTE );
BYTE HLSBAPI HlsGetSTNo( const UINT );
BOOL HLSBAPI HlsSetSTNo( const UINT, const BYTE );
WORD HLSBAPI HlsGetData( const UINT, const UINT );
BOOL HLSBAPI HlsSetData( const UINT, const UINT, const WORD );

BOOL HLSBAPI HlsSetIM( const BYTE );

// Compatible API
BOOL HLSBAPI HlsOpen( const WORD );
BOOL HLSBAPI HlsClose( void );
BOOL HLSBAPI HlsGetStatus( HlsbStat * );
BOOL HLSBAPI HlsSetDaeHi( const UINT );
BOOL HLSBAPI HlsSetDaeLo( const UINT );
BYTE HLSBAPI HlsGetIM( void );
BYTE HLSBAPI HlsGetII( void );
WORD HLSBAPI HlsGetChk1( const UINT );
BOOL HLSBAPI HlsResetChk1( const UINT );
WORD HLSBAPI HlsGetChk2( const UINT );
BOOL HLSBAPI HlsResetChk2( const UINT );
void HLSBAPI HlsResetBoard( void );
BOOL HLSBAPI HlsClrBoard( const int );
BOOL HLSBAPI HlsDialog( HWND );

BOOL HLSBAPI HlsAddBoard( const WORD );
BOOL HLSBAPI HlsSetCurrentBoard( const UINT );
UINT HLSBAPI HlsNumberOfChanel( void );

// Added Ver 2.00
BOOL HLSBAPI HlsSetStatus( const HlsbStat *stat );
INT HLSBAPI HlsCountDevice( void );
HANDLE HLSBAPI HlsOpenHandle( int Instance );
BOOL HLSBAPI HlsCloseHandle( HANDLE HLSBHandle );
BOOL HLSBAPI HlsReadDWord( HANDLE HLSBHandle, const ULONG Adr, const DWORD* Dat );
BOOL HLSBAPI HlsWriteDWord( HANDLE HLSBHandle, const ULONG Adr, const DWORD Dat );
BOOL HLSBAPI HlsReadByte( HANDLE HLSBHandle, const ULONG Adr, const BYTE* Dat );
BOOL HLSBAPI HlsReadWord( HANDLE HLSBHandle, const ULONG Adr, const WORD* Dat );
BOOL HLSBAPI HlsWriteByte( HANDLE HLSBHandle, const ULONG Adr, const BYTE Dat );
BOOL HLSBAPI HlsWriteWord( HANDLE HLSBHandle, const ULONG Adr, const WORD Dat );

BOOL HLSBAPI HlsGetIntCount( const UINT Count[8] );
BOOL HLSBAPI HlsGetDreqIntCount( const HANDLE HLSBHandle, const int ch, const ULONG* Count );
BOOL HLSBAPI HlsGetChk2IntCount( const HANDLE HLSBHandle, const int ch, const ULONG* Count );
BOOL HLSBAPI HlsGetScanrsIntCount( const HANDLE HLSBHandle, const int ch, const ULONG* Count );
BOOL HLSBAPI HlsGetScanwsIntCount( const HANDLE HLSBHandle, const int ch, const ULONG* Count );

#ifdef __cplusplus
}
#endif
